unit Silence;

interface

uses AviWriter_2, SysUtils, MMsystem;


function GetSilence(Info: TAviStreamInfo; Wavefmt: TWaveFormatEx; var Size: integer): PByteArray;


implementation

const PCM44100_16_2: array[0..63] of byte
  = ($00,$00,$06,$00,$01,$00,$06,$00,$00,$00,$05,$00,$01,$00,$06,$00,$01,$00,$06,$00,$01,$00,$07,$00,$02,$00,$07,$00,$02,$00,$06,$00,$02,$00,$08,$00,$03,$00,$07,$00,$03,$00,$08,$00,$02,$00,$08,$00,$04,$00,$07,$00,$04,$00,$08,$00,$04,$00,$09,$00,$04,$00,$09,$00);
const PCM48000_16_2: array[0..63] of byte
  = ($00,$00,$06,$00,$01,$00,$07,$00,$00,$00,$06,$00,$01,$00,$07,$00,$01,$00,$07,$00,$01,$00,$07,$00,$02,$00,$07,$00,$02,$00,$07,$00,$02,$00,$08,$00,$02,$00,$07,$00,$02,$00,$09,$00,$03,$00,$09,$00,$03,$00,$08,$00,$04,$00,$08,$00,$04,$00,$09,$00,$04,$00,$09,$00);
const PCM32075_16_2: array[0..63] of byte
  = ($01,$00,$06,$00,$00,$00,$05,$00,$01,$00,$06,$00,$01,$00,$06,$00,$02,$00,$07,$00,$02,$00,$07,$00,$03,$00,$07,$00,$02,$00,$07,$00,$02,$00,$08,$00,$03,$00,$08,$00,$03,$00,$08,$00,$04,$00,$08,$00,$04,$00,$09,$00,$04,$00,$09,$00,$06,$00,$08,$00,$05,$00,$08,$00);
const PCM32000_16_2: array[0..63] of byte
  = ($00,$00,$05,$00,$00,$00,$06,$00,$01,$00,$06,$00,$02,$00,$06,$00,$02,$00,$07,$00,$02,$00,$07,$00,$02,$00,$08,$00,$02,$00,$08,$00,$02,$00,$08,$00,$03,$00,$08,$00,$03,$00,$09,$00,$04,$00,$09,$00,$05,$00,$09,$00,$05,$00,$09,$00,$04,$00,$09,$00,$05,$00,$09,$00);
const PCM22050_16_2: array[0..63] of byte
  = ($FF,$FF,$06,$00,$01,$00,$06,$00,$01,$00,$07,$00,$02,$00,$06,$00,$02,$00,$07,$00,$03,$00,$07,$00,$03,$00,$08,$00,$04,$00,$08,$00,$05,$00,$09,$00,$04,$00,$09,$00,$05,$00,$09,$00,$05,$00,$09,$00,$05,$00,$0A,$00,$07,$00,$0A,$00,$07,$00,$0A,$00,$06,$00,$0A,$00);
const PCM16000_16_2: array[0..63] of byte
  = ($FF,$FF,$06,$00,$01,$00,$07,$00,$01,$00,$07,$00,$02,$00,$08,$00,$03,$00,$09,$00,$04,$00,$09,$00,$05,$00,$09,$00,$05,$00,$0A,$00,$05,$00,$0A,$00,$06,$00,$0B,$00,$07,$00,$0A,$00,$07,$00,$0A,$00,$08,$00,$0A,$00,$08,$00,$0A,$00,$09,$00,$0A,$00,$09,$00,$09,$00);
const PCM11025_16_2: array[0..63] of byte
  = ($01,$00,$06,$00,$01,$00,$07,$00,$02,$00,$08,$00,$03,$00,$08,$00,$04,$00,$09,$00,$06,$00,$09,$00,$06,$00,$0B,$00,$06,$00,$0A,$00,$08,$00,$0B,$00,$08,$00,$0A,$00,$09,$00,$0B,$00,$08,$00,$0A,$00,$09,$00,$0A,$00,$09,$00,$09,$00,$09,$00,$08,$00,$09,$00,$08,$00);
const PCM48000_16_1: array[0..31] of byte
  = ($00,$00,$00,$00,$01,$00,$00,$00,$01,$00,$02,$00,$02,$00,$01,$00,$03,$00,$03,$00,$03,$00,$02,$00,$04,$00,$04,$00,$04,$00,$04,$00);
const PCM44100_16_1: array[0..31] of byte
  = ($01,$00,$00,$00,$01,$00,$00,$00,$01,$00,$01,$00,$02,$00,$02,$00,$03,$00,$02,$00,$04,$00,$03,$00,$03,$00,$03,$00,$04,$00,$05,$00);
const PCM32000_16_1: array[0..31] of byte
  = ($FF,$FF,$00,$00,$01,$00,$02,$00,$02,$00,$02,$00,$02,$00,$03,$00,$03,$00,$04,$00,$03,$00,$04,$00,$05,$00,$05,$00,$05,$00,$05,$00);
const PCM22050_16_1: array[0..31] of byte
  = ($01,$00,$01,$00,$02,$00,$02,$00,$02,$00,$03,$00,$03,$00,$04,$00,$04,$00,$05,$00,$05,$00,$07,$00,$07,$00,$07,$00,$07,$00,$07,$00);
const PCM16000_16_1: array[0..31] of byte
  = ($01,$00,$01,$00,$02,$00,$02,$00,$04,$00,$03,$00,$05,$00,$06,$00,$06,$00,$07,$00,$08,$00,$08,$00,$08,$00,$09,$00,$08,$00,$09,$00);
const PCM11025_16_1: array[0..31] of byte
  = ($00,$00,$02,$00,$02,$00,$03,$00,$04,$00,$05,$00,$07,$00,$08,$00,$08,$00,$09,$00,$09,$00,$09,$00,$09,$00,$0A,$00,$09,$00,$09,$00);
const PCM48000_8_2: array[0..31] of byte
  = ($80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80);
const PCM44100_8_2: array[0..31] of byte
  = ($7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F);
const PCM32075_8_2: array[0..31] of byte
  = ($80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80);
const PCM32000_8_2: array[0..31] of byte
  = ($80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80);
const PCM22050_8_2: array[0..31] of byte
  = ($80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80);
const PCM16000_8_2: array[0..31] of byte
  = ($7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F);
const PCM11025_8_2: array[0..31] of byte
  = ($80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80);
const PCM48000_8_1: array[0..15] of byte
  = ($80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80);
const PCM44100_8_1: array[0..15] of byte
  = ($80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80);
const PCM32075_8_1: array[0..15] of byte
  = ($7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F);
const PCM32000_8_1: array[0..15] of byte
  = ($7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F);
const PCM22050_8_1: array[0..15] of byte
  = ($7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F);
const PCM16000_8_1: array[0..15] of byte
  = ($80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80, $80);
const PCM11025_8_1: array[0..15] of byte
  = ($7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F, $7F);

function GetSilence(Info: TAviStreamInfo; Wavefmt: TWaveFormatEx; var Size: integer): PByteArray;
var Rate, chan, Bits: integer;
begin
  Result := nil;
  Size := 0;
  Rate := Wavefmt.nSamplesPerSec;
  chan := Wavefmt.nChannels;
  Bits := Wavefmt.wBitsPerSample;
  with Info do
  begin
    if chan = 2 then
    begin
      if (Rate = 44100) and (Bits = 16) then
      begin
        Result := @PCM44100_16_2;
        Size := 64;
        exit;
      end;
      if (Rate = 48000) and (Bits = 16) then
      begin
        Result := @PCM48000_16_2;
        Size := 64;
        exit;
      end;
      if (Rate = 32075) and (Bits = 16) then
      begin
        Result := @PCM32075_16_2;
        Size := 64;
        exit;
      end;
      if (Rate = 32000) and (Bits = 16) then
      begin
        Result := @PCM32000_16_2;
        Size := 64;
        exit;
      end;
      if (Rate = 22050) and (Bits = 16) then
      begin
        Result := @PCM22050_16_2;
        Size := 64;
        exit;
      end;
      if (Rate = 16000) and (Bits = 16) then
      begin
        Result := @PCM16000_16_2;
        Size := 64;
        exit;
      end;
      if (Rate = 11025) and (Bits = 16) then
      begin
        Result := @PCM11025_16_2;
        Size := 64;
        exit;
      end;
      if (Rate = 44100) and (Bits = 8) then
      begin
        Result := @PCM44100_8_2;
        Size := 32;
        exit;
      end;
      if (Rate = 48000) and (Bits = 8) then
      begin
        Result := @PCM48000_8_2;
        Size := 32;
        exit;
      end;
      if (Rate = 32075) and (Bits = 8) then
      begin
        Result := @PCM32075_8_2;
        Size := 32;
        exit;
      end;
      if (Rate = 32000) and (Bits = 8) then
      begin
        Result := @PCM32000_8_2;
        Size := 32;
        exit;
      end;
      if (Rate = 22050) and (Bits = 8) then
      begin
        Result := @PCM22050_8_2;
        Size := 32;
        exit;
      end;
      if (Rate = 16000) and (Bits = 8) then
      begin
        Result := @PCM16000_8_2;
        Size := 32;
        exit;
      end;
      if (Rate = 11025) and (Bits = 8) then
      begin
        Result := @PCM11025_8_2;
        Size := 32;
        exit;
      end;
    end; //if chan=2;

    if chan = 1 then
    begin
      if (Rate = 44100) and (Bits = 16) then
      begin
        Result := @PCM44100_16_1;
        Size := 32;
        exit;
      end;
      if (Rate = 48000) and (Bits = 16) then
      begin
        Result := @PCM48000_16_1;
        Size := 32;
        exit;
      end;
      if (Rate = 32000) and (Bits = 16) then
      begin
        Result := @PCM32000_16_1;
        Size := 32;
        exit;
      end;
      if (Rate = 22050) and (Bits = 16) then
      begin
        Result := @PCM22050_16_1;
        Size := 32;
        exit;
      end;
      if (Rate = 16000) and (Bits = 16) then
      begin
        Result := @PCM16000_16_1;
        Size := 32;
        exit;
      end;
      if (Rate = 11025) and (Bits = 16) then
      begin
        Result := @PCM11025_16_1;
        Size := 32;
        exit;
      end;
      if (Rate = 44100) and (Bits = 8) then
      begin
        Result := @PCM44100_8_1;
        Size := 32;
        exit;
      end;
      if (Rate = 48000) and (Bits = 8) then
      begin
        Result := @PCM48000_8_1;
        Size := 16;
        exit;
      end;
      if (Rate = 32075) and (Bits = 8) then
      begin
        Result := @PCM32075_8_1;
        Size := 16;
        exit;
      end;
      if (Rate = 32000) and (Bits = 8) then
      begin
        Result := @PCM32000_8_1;
        Size := 16;
        exit;
      end;
      if (Rate = 22050) and (Bits = 8) then
      begin
        Result := @PCM22050_8_1;
        Size := 16;
        exit;
      end;
      if (Rate = 16000) and (Bits = 8) then
      begin
        Result := @PCM16000_8_1;
        Size := 16;
        exit;
      end;
      if (Rate = 11025) and (Bits = 8) then
      begin
        Result := @PCM11025_8_1;
        Size := 16;
        exit;
      end;
    end; //if chan=1;
  end;
end;

end.

